//-----------------------------------------------------------
// MapVote Mutator
// By BDB (Bruce Bickar)
// http://www.mapvote.com
//-----------------------------------------------------------
class BDBMapVote expands Mutator config;

var bool   bInitialized;
var string MapList[1024];        // list of all the maps available on the server
var int    PlayerIDList[32];    // list of player IDs, used for looking up the players index number   
var int    PlayerVote[32];      // index of the map that the player has voted for
var int    MapCount;            // total number of maps on server
var int    PlayerKickVote[32];  // list of kick votes per player
var string MapStatusText[100];
var string KickStatusText[100];
var string KickIPList[50];      // list of player IP addresses to kick
var float  EndGameTime;
var bool   bMidGameVote;
var int    CurrentID;
var int    JoinTickCount;       // number of ticks after player join

var() config bool bAutoDetect;
var() config bool bDM;
var() config bool bLMS;
var() config bool bTDM;
var() config bool bDOM;
var() config bool bCTF;
var() config bool bAS;
var() config bool bOther;
var() config string OtherClass;
var() config string MapPreFixOverRide; // tell it to load maps with this prefix instead of default
var() config string PreFixSwap;        // map name prefix to change too
var() config bool bSortWithPreFix;     // set false to ingnore prefix when sorting maps
var() config int VoteTimeLimit;
var() config int KickPercent;
var() config bool bUseMapList;
var() config int ScoreBoardDelay;
var() config bool bAutoOpen;
var() config bool bKickVote;
var() config bool bCheckOtherGameTie;
var() config int RepeatLimit;
var() config string MapVoteHistoryType;
var() config string ServerInfoURL;    //www.planetunreal.com:80/BDBUnreal/ServerInfo.htm
var() config string MapInfoURL;       //www.planetunreal.com:80/BDBUnreal/MapInfo/
var() config int MidGameVotePercent;
var() config string Mode;
var() config int MinMapCount;
var() config string HasStartWindow; // Yes,No,Auto - Does the game have a start menu
var() config bool bEntryWindows; // false = Dont open Welcome window or Keybinder when player enters
var() config bool bDebugMode;     // debug mode will log extra data to log
var() config string AccName[32];  // use for Accumulation mode
var() config int    AccVotes[32]; // use for Accumulation mode

// client side settings
var() config int MsgTimeOut;        
var() config bool bLoadScreenShot;

var int TimeLeft,ScoreBoardTime,ServerTravelTime;
var class<GameInfo> OtherGameClass;
var class<MapVoteHistory> MapVoteHistoryClass;
var bool bLevelSwitchPending;
var string ServerTravelString;
var int MarkedMapCount; // total number of maps that have not been elimitated.

//************************************************************************************************
function bool HandleEndGame()
{
   local Pawn aPawn;
   local bool bReturn;

   DebugLog("1");
   
	Super.HandleEndGame(); // pass along call to other mutators

   bReturn = false;

   if(!bAutoOpen || CheckForTie()) // Don't open voting windows for tied game or if disabled
   {
      DebugLog("2");
      return false;
   }

   // Do not mess with Assult games in mid game
   if(Level.Game.IsA('Assault'))
   {
      DebugLog("4");
      //log("Playing Assault, Check bDefense");
      if( !Assault(Level.Game).bDefenseSet )
      {
         //log("bDefenseSet == False, Ending game normally.(First half end)");
         return false;
      }
      else
      {
         //log("bDefense == True, calling ResetGame.(Second half end)");
         Assault(Level.Game).ResetGame();  // resets assault ini settings so next game starts on first half of game instead of second
      }
   }

   DebugLog("5");
   // Setting bDontRestart will give players time to vote
   DeathMatchPlus(Level.Game).bDontRestart = true;

   // Start voting count-down timer
   TimeLeft = VoteTimeLimit;
   ScoreBoardTime = ScoreBoardDelay;
   settimer(1,true);

   return bReturn;
}
//************************************************************************************************
event timer()
{
   local pawn aPawn;
   local int VoterNum,NoVoteCount,mapnum;
   local MapVoteWRI A;
   local Pawn P;

   if(bLevelSwitchPending)
   {
      DebugLog("6");
      if(Level.TimeSeconds > ServerTravelTime + 3) // Give a little extra time for windows to close
      {
         DebugLog("NextURL = " $ Level.NextURL);
	      Debuglog("NextSwitchCountdown = " $ Level.NextSwitchCountdown);
	     
         if( Level.NextURL == "" )
	      {
            DebugLog("7");
           
	         if(Level.NextSwitchCountdown < 0)  // if negative then level switch failed
	         {
	            Log("Map change Failed, bad or missing map file.");
	            mapnum = Rand(MapCount) + 1;
                   
	            while(Left(MapList[mapnum],3) == "[X]")  // don't allow elimiated maps
                  mapnum = Rand(MapCount) + 1;         // select a different map
               
               ServerTravelString = SetupGameMap(MapList[mapnum]);
               Level.ServerTravel(ServerTravelString, false);    // change the map
	         }
	         else
               Level.ServerTravel(ServerTravelString, false);    // change the map
	      }
      }
      return;
   }

   if(ScoreBoardTime > 0)
   {
      DebugLog("8");
      ScoreBoardTime--;
      if(ScoreBoardTime == 0)
      {
         DebugLog("9");
         EndGameTime = Level.TimeSeconds;

         // force all players voting window open
         for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
         {
            if(PlayerPawn(aPawn) != none && aPawn.bIsPlayer)
            {
               VoterNum = FindPlayerIndex(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID);
					if(VoterNum > -1)
                  if(PlayerVote[VoterNum] == 0) // if this player has not voted
                     OpenVoteWindow(PlayerPawn(aPawn));
            }
         }

         BroadcastMessage(String(TimeLeft) $" seconds left to vote.", true);
      }
      return;
   }
   TimeLeft--;

   //log(TimeLeft);
   if(TimeLeft == 60)  // play announcer voice for 1 minute warning
   {
      DebugLog("10");
      BroadcastMessage("1 Minute left to vote.", true);
      for( P = Level.PawnList; P!=None; P=P.nextPawn )
         if( P.IsA('TournamentPlayer') )
           TournamentPlayer(P).TimeMessage(12);
   }

   if(TimeLeft == 10)
   {
      DebugLog("11");
      BroadcastMessage("10 seconds left to vote.", true);
   }

   if(TimeLeft < 11 && TimeLeft > 0 )  // play announcer voice Count Down
   {
      for( P = Level.PawnList; P!=None; P=P.nextPawn )
         if( P.IsA('TournamentPlayer') )
            TournamentPlayer(P).TimeMessage(TimeLeft);
   }

   CleanUpPlayerIDs();

   if(TimeLeft % 20 == 0 && TimeLeft > 0)
   {
      DebugLog("12");
      NoVoteCount = 0;
      // force all players voting windows open if they have not voted
      for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
      {
         if(aPawn.bIsPlayer && PlayerPawn(aPawn) != none)
         {
            VoterNum = FindPlayerIndex(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID);
				if(VoterNum > -1)
				{
               if(PlayerVote[VoterNum] == 0) // if this player has not voted
               {
                  NoVoteCount++;
                  //OpenVoteWindow(PlayerPawn(aPawn));
               }
				}
         }
      }
      if(NoVoteCount == 0) // this should fix a problem cause by players leaving the game
      {
         DebugLog("13");
         TallyVotes(true); // all players have voted, so force a map change
      }
   }

   if(TimeLeft == 0)  // force level switch if time limit is up
   {
     DebugLog("14");
     TallyVotes(true);   // if no-one has voted a random map will be choosen
   }
}
//************************************************************************************************
function tick(float DeltaTime)
{
   local string PlayerName,PID;
   local int    TeamID;
   local Pawn   Other;

   Super.tick(DeltaTime);

   if(Level.Game.CurrentID > CurrentID) // at least one new player has joined
   {
      if(JoinTickCount < 20)  // added 20 tick delay too see if it reduces intermittant crash problem
      {
         if(JoinTickCount == 0)
            DebugLog("15");
         JoinTickCount++;
         return;
      }

      DebugLog("16");

      JoinTickCount = 0;
      // Find the new player
      for( Other=Level.PawnList; Other!=None; Other=Other.NextPawn )
         if(Other.PlayerReplicationInfo.PlayerID == CurrentID)
            break;

      CurrentID++;

      // Ignore Bots and other none playerpawns
      if(Other == None || !Other.bIsPlayer || !Other.IsA('PlayerPawn'))
      {
         DebugLog("17");
         return;
      }

      Log("New Player " $ Other.PlayerReplicationInfo.PlayerName $ ", " $ PlayerPawn(Other).GetPlayerNetworkAddress());

      if(bKickVote)
      {
         DebugLog("18");

         if(CheckKickIP(PlayerPawn(Other).GetPlayerNetworkAddress())) // check players IP address
         {
            DebugLog("19");
            BroadcastMessage(Other.PlayerReplicationInfo.PlayerName $ " has been refused access to the server.", true);
            Other.Destroy();    // Re-Kick this player
            return;
         }

         if(Other.IsA('Spectator'))
            TeamID = 9;
         else
         {
            if(PlayerPawn(Other).PlayerReplicationInfo.Team == 255)
               TeamID = 0;
            else
               TeamID = PlayerPawn(Other).PlayerReplicationInfo.Team;
         }

         PID = right("000" $ PlayerPawn(Other).PlayerReplicationInfo.PlayerID,3);

         PlayerName = TeamID $ PID $ PlayerPawn(Other).PlayerReplicationInfo.PlayerName;
         AddNewPlayer(PlayerName);

         DebugLog("20");
         // add the PlayerID to the PlayerIDList
         FindPlayerIndex(PlayerPawn(Other).PlayerReplicationInfo.PlayerID);
      }

      if(bEntryWindows && !Other.IsA('Spectator'))
      {
         DebugLog("21");
         if(Level.Game.IsA('Assault') && Assault(Level.Game).bDefenseSet)  // dont open for second half of Assault game
         {
            DebugLog("22");
            return;
         }
         if(Level.Game.bGameEnded)
         {
            DebugLog("23");
            if(bAutoOpen)
               OpenVoteWindow(PlayerPawn(Other));   // open the voting window
         }
         else
            OpenWelcomeWindow(PlayerPawn(Other)); //open the welcome window
      }
      DebugLog("24");
   }
}
//************************************************************************************************
function bool CheckForTie()
{
  local TeamInfo Best;
  local int i;
  local pawn P, BestP;
  local PlayerPawn Player;

  DebugLog("25");
  if(Level.Game.IsA('Assault'))  //cant have ties in Assault, I think ?
     return false;

  if(Level.Game.IsA('Domination'))  //cant have ties in Domination, I think ?
     return false;

  // No ties in RocketArena, StrikeForce, etc.
  if(bOther &&
     !bCheckOtherGameTie &&
     Level.Game.MapPrefix ~= OtherGameClass.default.MapPreFix)
     return false;

  if(Level.Game.IsA('TeamGamePlus'))  // check for a team game tie
  {
     DebugLog("26");
     // find best team
     for( i=0; i<TeamGamePlus(Level.Game).MaxTeams; i++ )
       if( (Best == None) || (Best.Score < TeamGamePlus(Level.Game).Teams[i].Score) )
          Best = TeamGamePlus(Level.Game).Teams[i];

     for( i=0; i<TeamGamePlus(Level.Game).MaxTeams; i++ )
          if( (Best.TeamIndex != i) && (Best.Score == TeamGamePlus(Level.Game).Teams[i].Score) )
             return true;  // teams tied
  }
  else   // check for death match tie
  {
     DebugLog("27");
     // find individual winner
     for( P=Level.PawnList; P!=None; P=P.nextPawn )
        if( P.bIsPlayer && ((BestP == None) || (P.PlayerReplicationInfo.Score > BestP.PlayerReplicationInfo.Score)) )
           BestP = P;
     // check for tie
     for ( P=Level.PawnList; P!=None; P=P.nextPawn )
          if ( P.bIsPlayer && (BestP != P) && (P.PlayerReplicationInfo.Score == BestP.PlayerReplicationInfo.Score) )
               return true; // tied
  }
  return false;  // No tie
}
//************************************************************************************************
function SubmitVote(string MapName,Actor Voter)
{
   local int PlayerIndex,x,MapIndex;

   DebugLog("28");
   //log(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has voted for " $ MapName);

	if(bLevelSwitchPending)
	   return;
	
   if(Voter.IsA('Spectator'))
      return; // spectators can not vote

   if(Left(MapName,3) == "[X]") // check for maps that have been marked as not playable.
      return; // ah ah ah, no no no, you didn't say the secret password   
      
   CleanUpPlayerIDs();

   PlayerIndex = FindPlayerIndex(PlayerPawn(Voter).PlayerReplicationInfo.PlayerID);
   if(PlayerIndex == -1)
	   return;

   //look up map index
   for(x=1; x<=MapCount; x++)
   {
      if(MapList[x] == MapName)
      {
         MapIndex = x;
         break;
      }
   }

   if(MapIndex == 0) // if map not found stop
      return;

   if(PlayerVote[PlayerIndex] == MapIndex) // voted for same map don't tally.
      return;

   PlayerVote[PlayerIndex] = MapIndex;
   if(Mode == "Accumulation")
   {
      DebugLog("29");
      BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has placed " $ GetAccVote(PlayerIndex) $ " votes for " $ MapName, true);
   }
   else
      if(Mode == "Score")
         BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has placed " $ GetPlayerScore(PlayerIndex) $ " votes for " $ MapName, true);
      else
         BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " voted for " $ MapName, true);

   TallyVotes(false);
}
//******************************************************************************
function SubmitKickVote(int PlayerID,Actor Voter)
{
   local Pawn aPawn;
   local int VoterNum,x,y,VoteCount[32],Lamer;

   DebugLog("30");

	if(bLevelSwitchPending)
	   return;
		
   if(Voter.IsA('Spectator'))
      return; // spectators can not vote

   if(!bKickVote)
      return; // kick voting disabled

   if(PlayerID < 0 || PlayerID > 999)
	   return;

   CleanUpPlayerIDs();

   // Get the index of the voter
   VoterNum = FindPlayerIndex(PlayerPawn(Voter).PlayerReplicationInfo.PlayerID);
   if(VoterNum == -1)
	   return;
	
	if(FindPlayerIndex(PlayerID) == -1)
	   return;
	
   if(PlayerKickVote[VoterNum] == FindPlayerIndex(PlayerID)) // if vote is for same player stop
      return;

   // find and store the player index of the Player bing kicked
   for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
   {
      if(aPawn.bIsPlayer && aPawn.PlayerReplicationInfo.PlayerID == PlayerID)
      {
         if(NetConnection(PlayerPawn(aPawn).Player) == None || PlayerPawn(aPawn).bAdmin)
         {
            PlayerPawn(Voter).ClientMessage("Sorry, You can Not kick the Server or the Admin.");
            return;
         }
         else
         {
            PlayerKickVote[VoterNum] = FindPlayerIndex(PlayerID);
            BroadcastMessage("A Kick Vote has been placed against "$aPawn.PlayerReplicationInfo.PlayerName, true);
         }
      }
   }

   // tally up the votes
   for(x=0;x<32;x++) // for each player
   {
      if(PlayerKickVote[x] != -1) // if this player has voted
      {
         VoteCount[PlayerKickVote[x]]++; // increment the votecount for this player
      }
   }

   // find the player with the highest number of kick votes
   Lamer = 0;
   for(x=1; x<=32; x++)
   {
      if(VoteCount[x] > VoteCount[Lamer])
         Lamer = x;
   }

   // if more than KickPercent of the players voted to kick this lamer then kick him/her
   if( (float(VoteCount[Lamer])/float(Level.Game.NumPlayers))*100 >= KickPercent)
   {
      DebugLog("31");
      KickPlayer(PlayerIDList[Lamer]);
      PlayerVote[Lamer] = 0;
      VoteCount[Lamer] = 0;
      PlayerKickVote[Lamer] = -1;
      PlayerIDList[Lamer] = -1;
   }

   //Update kick Status
   for(x=0; x<32; x++)
   {
      if(VoteCount[x] > 0)
         KickStatusText[y++] = GetPlayerName(PlayerIDList[x]) $ "," $ VoteCount[x];
   }
   KickStatusText[y]="";

   UpdateOpenWRI();
   DebugLog("32");
}
//************************************************************************************************
function KickPlayer(int PlayerID)
{
  local Pawn aPawn;
  local string IP;
  local string PID;
  local MapVoteWRI MVWRI;

  DebugLog("33");

  for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
  {
     if(aPawn.bIsPlayer &&
        aPawn.PlayerReplicationInfo.PlayerID == PlayerID &&
        (PlayerPawn(aPawn)==None || NetConnection(PlayerPawn(aPawn).Player)!=None )
       )
     {
        BroadcastMessage(aPawn.PlayerReplicationInfo.PlayerName $ " has been kicked.", true);
        IP = PlayerPawn(aPawn).GetPlayerNetworkAddress();
        AddKickIP(IP);

        if(bKickVote)
        {
           PID = right("000" $ aPawn.PlayerReplicationInfo.PlayerID,3);
           RemovePlayerName(right("000" $ PID,3));
        }

        //close his/her voting window if open
        foreach AllActors(class'BDBMapVote304.MapVoteWRI',MVWRI) // check all existing WRIs
        {
           if(aPawn == MVWRI.Owner)
           {
              MVWRI.CloseWindow();
              MVWRI.Destroy();
              break;
           }
        }

        aPawn.Destroy();   // kick
        return;
     }
  }
  DebugLog("34");
}
//************************************************************************************************
function AddKickIP(string IP)
{
   local int i,p;
   local string ShortIP;

   DebugLog("35");

   if(IP == "")
      return;

   p = InStr(IP,":");
   if(p > -1)
     ShortIP = left(IP,p);
   else
     ShortIP = IP;

   //log("AddKickIP >" $ ShortIP $ "<");

   for(i=0;i<49;i++)
   {
      if(KickIPList[i]=="")
      {
         KickIPList[i] = ShortIP;
         return;
      }
   }
   DebugLog("36");
}
//************************************************************************************************
function bool CheckKickIP(string IP)  // returns true if the address is in the kick list
{
   local int i,p;
   local string ShortIP;

   DebugLog("37");

   if(IP == "")
      return false;

   p = InStr(IP,":");
   if(p > -1)
     ShortIP = left(IP,p);
   else
     ShortIP = IP;

   //Log("CheckKickIP >" $ ShortIP $ "<");

   for(i=0;i<50;i++)
   {
      if(KickIPList[i] == ShortIP)
      {
         return true;
      }
   }
   DebugLog("38");
   return false;
}
//************************************************************************************************
simulated function PreBeginPlay()
{
   local int x;

   DebugLog("39");

   if(!bInitialized)
   {
      DebugLog("40");
      //log("PreBeginPlay...");
      // initialize PlayerIDList
      for(x=0;x<32;x++)
      {
         PlayerIDList[x] = -1;
         PlayerKickVote[x] = -1;
      }

      for(x=0;x<50;x++)
         KickIPList[x]="";

      LoadMaps();    // load all the map names in the maplist array
      SortMapList(); // sort the maplist in alphabetic order

      bInitialized = true;
   }

   DebugLog("41");

   Super.PostBeginPlay();
}
//************************************************************************************************
function Mutate(string MutateString, PlayerPawn Sender)
{
   local string MapName;
   local string PlayerName;
   local int PlayerID,pos,seq;
   local MapVoteReport MVReport;
   local int ObjectCount;
   local MapVoteWRI MVWRI;
   local MapVoteHistory MVHistory;

   Super.Mutate(MutateString, Sender);

   //log(">"$MutateString$"<");
   //       012345678901234567890
   //MUTATE BDBMAPVOTE VOTEMENU
   if(left(Caps(MutateString),10) == "BDBMAPVOTE")
   {
      DebugLog("42");
      if(Mid(Caps(MutateString),11,8) == "VOTEMENU")
      {
         DebugLog("43");
         if(Level.TimeSeconds > 20 || Level.Netmode == NM_Standalone)  // make sure they cant vote before other players have joined server
         {
            if(!Sender.IsA('Spectator'))
            {
               CleanUpPlayerIDs();
               OpenVoteWindow(Sender);
            }
            else
               Sender.ClientMessage("Spectators are not allowed to vote.");
         }
         else
         {
            Sender.ClientMessage("Please Wait 20 seconds to vote");
         }
      }
      //---------------------------------------------
      if(Mid(Caps(MutateString),11,3) == "MAP")
      {
         DebugLog("44");
         MapName = mid(MutateString,15);
         if(Sender.bAdmin)
         {
 	         if(Left(MapName,3) == "[X]")
				   MapName = mid(MapName,3); // remove [X]
            BroadcastMessage("Server Admin has force a map switch to " $ MapName , true);
            ServerTravelString = SetupGameMap(MapName);
            CloseAllVoteWindows();
            Level.ServerTravel(ServerTravelString, false);    // change the map
         }
	      else
	      {  
            SubmitVote(MapName,Sender);
	      }
      }
      //---------------------------------------------
      if(Mid(Caps(MutateString),11,4) == "KICK")
      {
         DebugLog("45");
         //TIIINNNNNNNNN  1001BDB
         PlayerName = mid(MutateString,16);
         PlayerID = int(Mid(left(PlayerName,4),2));

         if(Sender.bAdmin)
         {
			KickPlayer(PlayerID);
		 }
		 else
		 {
			 SubmitKickVote(PlayerID,Sender);
		 }
      }
      //---------------------------------------------
      if(Mid(Caps(MutateString),11,10) == "RELOADMAPS")
      {
         DebugLog("46");
         if(Sender.bAdmin)
         {
            DebugLog("47");
            LoadMaps();
            SortMapList();
            BroadcastMessage("MapVote configuration has been changed, Re-Open Voting window for updates.", true);
         }
      }
      //---------------------------------------------
      if(Mid(Caps(MutateString),11,6) == "REPORT")
      {
         DebugLog("48");
    
         // count MapVoteReports
         ObjectCount = 0;
         foreach AllActors(class'MapVoteReport',MVReport)
            ObjectCount++;
	 
	 if(ObjectCount > 0)
	 {   
            Sender.ClientMessage("Sorry, The server can only run one report at a time, please try again later.");
	    return;
	 }
	 
         MVReport = spawn(class'MapVoteReport');
         if(MVReport != none)
            MVReport.RunRport(Caps(Mid(MutateString,18)), Sender, MapVoteHistoryClass);
         else
            log("Failed to spawn MVReport");
      }
      //---------------------------------------------
      if(Mid(Caps(MutateString),11,6) == "STATUS")
      {
         DebugLog("49");
         Sender.ClientMessage("Total Map Count is " $ MapCount);

         // count MapVoteWRIs
         ObjectCount = 0;
         foreach AllActors(class'MapVoteWRI',MVWRI)
            ObjectCount++;
         Sender.ClientMessage("Active MapVoteWRI count is " $ ObjectCount);

         // count MapVoteReports
         ObjectCount = 0;
         foreach AllActors(class'MapVoteReport',MVReport)
            ObjectCount++;
         Sender.ClientMessage("Active MapVoteReport count is " $ ObjectCount);

         // count MapVoteHistorys
         ObjectCount = 0;
         foreach AllActors(class'MapVoteHistory',MVHistory)
            ObjectCount++;
         Sender.ClientMessage("Active MapVoteHistory count is " $ ObjectCount);
      }
      //---------------------------------------------
      //       0123456789012345678901234567890
      //MUTATE BDBMAPVOTE SETSEQ MAPNAME -1
      if(Mid(Caps(MutateString),11,6) == "SETSEQ")
      {
         DebugLog("50");
         if(Sender.bAdmin)
         {
            MapName = Mid(MutateString,18);
            pos = InStr(MapName," ");
            if(pos < 1)
            {
               Sender.ClientMessage("Syntax Error");
               return;
            }
            seq = int(Mid(MapName,pos+1));
            MapName = Left(MapName,pos);
            MVHistory = spawn(MapVoteHistoryClass);
            MVHistory.SetMapSequence(MapName,seq);
            MVHistory.Save();
            MVHistory.Destroy();
            Sender.ClientMessage("Sequence changed !");
         }
         else
            Sender.ClientMessage("You must be a server admin to perform this fuction !");
      }
      //---------------------------------------------
      //       0123456789012345678901234567890
      //MUTATE BDBMAPVOTE SETPC MAPNAME -1
      if(Mid(Caps(MutateString),11,5) == "SETPC")
      {
         DebugLog("51");
         if(Sender.bAdmin)
         {
            MapName = Mid(MutateString,17);
            pos = InStr(MapName," ");
            if(pos < 1)
            {
               Sender.ClientMessage("Syntax Error");
               return;
            }
            seq = int(Mid(MapName,pos+1));
            MapName = Left(MapName,pos);
            MVHistory = spawn(MapVoteHistoryClass);
            MVHistory.SetPlayCount(MapName,seq);
            MVHistory.Save();
            MVHistory.Destroy();
            Sender.ClientMessage("PlayCount changed !");
         }
         else
            Sender.ClientMessage("You must be a server admin to perform this fuction !");
      }
   }
}
//************************************************************************************************
function OpenVoteWindow(PlayerPawn Sender)
{
   local MapVoteWRI MVWRI;
   local int x,playercount,y,i;
   local pawn p;
   local MapVoteWRI A;
   local int TeamID;
   local string PID;

   DebugLog("52");

   if(Sender.IsA('Spectator'))
      return; // don't open voting window for spectators

	if(bLevelSwitchPending)
	   return;
		
   // check if window already open
   foreach AllActors(class'BDBMapVote304.MapVoteWRI',A) // check all existing WRIs
   {
      if(Sender == A.Owner)
      {
         DebugLog("53");
         return;            // dont open if already open
      }
   }

   MVWRI = Spawn(class'BDBMapVote304.MapVoteWRI',Sender,,Sender.Location);
   if(MVWRI==None)
   {
      Log("#### -- PostLogin :: Fail:: Could not spawn WRI");
      return;
   }

   // transfer map list to the WRI
   MVWRI.MapCount = MapCount;
   //for(x=1;x<=MapCount;x++)
   //   MVWRI.MapList[x] = MapList[x];

   //  Map Number  List
   //  ----------- ----------
   //  1   - 255   MapList1
   //  256 - 510   MapList2
   //  511 - 765   MapList3
   //  766 - 1020  MapList4

   for(i=1;i<=MapCount;i++)
   {
      if(i < 256)
         MVWRI.MapList1[i] = MapList[i];
      if(i >= 256 && i < 511)
         MVWRI.MapList2[i - 255] = MapList[i];
      if(i >= 511 && i < 766)
         MVWRI.MapList3[i - 510] = MapList[i];
      if(i >= 766)
         MVWRI.MapList4[i - 765] = MapList[i];
   }
   MVWRI.MapVoteMutator = self;

   // transfer player list to WRI
   if(bKickVote)
   {
      DebugLog("54");
      playercount=0;
      for(p=Level.PawnList; p!=None; p=p.nextPawn)
      {
         if(PlayerPawn(p) != none && p.bIsPlayer)
         {
            if(p.IsA('Spectator'))
               TeamID = 9;
            else
            {
               if(PlayerPawn(p).PlayerReplicationInfo.Team == 255)
                  TeamID = 0;
               else
                  TeamID = PlayerPawn(p).PlayerReplicationInfo.Team;
            }

            PID = right("000" $ PlayerPawn(p).PlayerReplicationInfo.PlayerID,3);

            MVWRI.PlayerName[playercount++] = TeamID $ PID $ PlayerPawn(p).PlayerReplicationInfo.PlayerName;
            // example: 1004BDB  =  Team 1, PlayerID 4, PlayerName BDB
         }
      }
      MVWRI.PlayerCount = playercount;
   }

   // transfer Map Voting Status to status page window
   x=0;
   while(MapStatusText[x] != "" && x<99)
   {
      MVWRI.MapVoteResults[x] = MapStatusText[x];
      x++;
   }
   MVWRI.MapVoteResults[x]="";

   y=0;
   // transfer Player Kick Voting Status to status page window
   if(bKickVote)
   {
      DebugLog("55");
      while(KickStatusText[y] != "" && y<99)
      {
         MVWRI.KickVoteResults[y] = KickStatusText[y++];
      }
      MVWRI.KickVoteResults[y] = ""; // Mark the end
   }
   MVWRI.GetServerConfig();
   DebugLog("56");
}
//************************************************************************************************
function OpenWelcomeWindow(PlayerPawn Sender)
{
   local MVWelcomeWRI MVWWRI;
   local MVWelcomeWRI A;

   DebugLog("57");

   if(Sender.IsA('Spectator'))
      return; // don't open window for spectators

   // check if window already open
   foreach AllActors(class'BDBMapVote304.MVWelcomeWRI',A) // check all existing WRIs
   {
      if(Sender == A.Owner)
         return;            // dont open if already open
   }

   MVWWRI = Spawn(class'BDBMapVote304.MVWelcomeWRI',Sender,,Sender.Location);
   if(MVWWRI==None)
   {
      Log("#### -- PostLogin :: Fail:: Could not spawn MVWelcomeWRI");
      return;
   }
   if(HasStartWindow == "Yes")
      MVWWRI.bHasStartWindow = True;
   else
      MVWWRI.bHasStartWindow = False;
   MVWWRI.GetServerConfig();
   DebugLog("58");
}
//************************************************************************************************
function int FindPlayerIndex(int PlayerID)
{
   // this funtion maintains the list of players
   // uses the PlayerID which should be unique for every player
   local int x;

   DebugLog("59");

   // find the PlayerID in PlayerIDList array if it exists
   for(x=0;x<32;x++)
   {
      if(PlayerIDList[x] == PlayerID)
         return x;
   }

   // not found, so add to bottom of array
   for(x=0;x<32;x++)
   {
      if(PlayerIDList[x]==-1)
      {
         PlayerIDList[x]=PlayerID;
         return x;
      }
   }
	log("MAPVOTE ERROR ---- Could not find PlayerIndex");
   DebugLog("60");
	return -1;
}
//************************************************************************************************
function AddNewPlayer(string NewPlayerName)  //adds a player name to all open Voting windows
{
   local MapVoteWRI MVWRI;
   local pawn p;

   DebugLog("61");

   foreach AllActors(class'BDBMapVote304.MapVoteWRI',MVWRI) // check all existing WRIs
   {
      MVWRI.AddNewPlayer(NewPlayerName);
   }
   DebugLog("62");
}
//************************************************************************************************
function RemovePlayerName(string OldPlayerName)  // removes a players name from all open Voting windows
{
   local MapVoteWRI MVWRI;
   local pawn p;

   DebugLog("63");

   //Log("RemovePlayerName(" $ OldPlayerName $ ")");

   foreach AllActors(class'BDBMapVote304.MapVoteWRI',MVWRI) // check all existing WRIs
   {
      MVWRI.RemovePlayerName(OldPlayerName);
   }
}
//************************************************************************************************
function CleanUpPlayerIDs()
{
   // This fuction removes the player vote info that belongs to players
   // that have left the game
   local Pawn aPawn;
   local int x;
   local bool bFound;

   DebugLog("64");

   for(x=0;x<32;x++)
   {
      //log("x = " $ x $ " , PlayerIDList[x] = " $ PlayerIDList[x]);
      if(PlayerIDList[x]>-1)
      {
         bFound = false;
         for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
         {
            if(aPawn.bIsPlayer && aPawn.IsA('PlayerPawn') && PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerIDList[x])
            {
               bFound = true;
               break;
            }
         }
         if(!bFound)
         {
            if(bKickVote)
               RemovePlayerName(right("000" $ PlayerIDList[x],3));
            PlayerVote[x] = 0;              
            PlayerKickVote[x] = -1;    
            PlayerIDList[x] = -1;
         }
      }
   }
   DebugLog("65");
}
//************************************************************************************************
function string GetPlayerName(int PlayerID)
{
   local pawn aPawn;
   local string PlayerName;

   DebugLog("66");

   PlayerName="unknown";
   for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
   {
      if(aPawn.bIsPlayer && PlayerPawn(aPawn) != None)
      {
         if(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerID)
         {
            PlayerName = right("000" $ PlayerID,3) $ aPawn.PlayerReplicationInfo.PlayerName;
            break;
         }
      }
   }
   return PlayerName;
}
//******************************************************************************
function float GetPlayerScore(int PlayerIndex)
{
   local pawn aPawn;
   local float PlayerScore;

   DebugLog("67");

   for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
   {
      if(aPawn.bIsPlayer && PlayerPawn(aPawn) != None)
      {
         if(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerIDList[PlayerIndex])
         {
            PlayerScore = PlayerPawn(aPawn).PlayerReplicationInfo.Score;
            break;
         }
      }
   }
   if(PlayerScore < 1)
      PlayerScore = 1;

   return PlayerScore;
}
//******************************************************************************
function int GetAccVote(int PlayerIndex)
{
   local pawn aPawn;
   local int x,PlayerAccVotes;
   local string PlayerName;

   DebugLog("68");
   // Find the Players Name
   for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
   {
      if(aPawn.bIsPlayer && PlayerPawn(aPawn) != None)
      {
         if(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerIDList[PlayerIndex])
         {
            PlayerName = PlayerPawn(aPawn).PlayerReplicationInfo.PlayerName;
            break;
         }
      }
   }

   if(PlayerName == "")
      return(0);

   // Find the players name in the saved accumulated votes
   for(x=0;x<32;x++)
   {
      if(AccName[x] == PlayerName)
      {
         PlayerAccVotes = AccVotes[x];
         break;
      }
   }

   if(PlayerAccVotes > 0)
      return(PlayerAccVotes); // if found return the saved vote count

   // Not found, so find an empty slot and save it
   for(x=0;x<32;x++)
   {
      if(AccName[x] == "")
      {
         AccName[x] = PlayerName;
         AccVotes[x] = 1;
         break;
      }
   }
   DebugLog("69");
   return(1);
}
//******************************************************************************
function SaveAccVotes(int WinningMapIndex)
{
   local pawn aPawn;
   local int x;
   local bool bFound;

   DebugLog("70");

   for(x=0;x<32;x++)
   {
      if(AccName[x] != "")
      {
         bFound = false;
         for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
         {
            if(aPawn.bIsPlayer && PlayerPawn(aPawn) != None)
            {
               if(AccName[x] == PlayerPawn(aPawn).PlayerReplicationInfo.PlayerName)
               {
                  if(PlayerVote[FindPlayerIndex(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID)] != WinningMapIndex)
                  {
                     bFound = true;
                     AccVotes[x]++;
                  }
                  break;
               }
            }
         }
         if(!bFound)  // If this player is not here anymore remove his/her votes
         {
            AccName[x] = "";
            AccVotes[x] = 0;
         }
      }
   }
   // save votes to ini file
   for(x=0;x<32;x++)
   {
      class'BDBMapVote304.BDBMapVote'.default.AccName[x] = AccName[x];
      class'BDBMapVote304.BDBMapVote'.default.AccVotes[x] = AccVotes[x];
   }
   class'BDBMapVote304.BDBMapVote'.static.StaticSaveConfig();
   DebugLog("71");
}
//******************************************************************************
function TallyVotes(bool bForceMapSwitch)
{
   local string MapName;
   local Actor  A;
   local int    index,x,y,topmap;
   local int    VoteCount[1024];
   local int    Ranking[32];
   local int    PlayersThatVoted;
   local int    TieCount;
   local string GameType,CurrentMap;
   local int i,textline;
   local MapVoteHistory History;

   DebugLog("72");

	if(bLevelSwitchPending)
	   return;
	
   PlayersThatVoted = 0;
   for(x=0;x<32;x++) // for each player
   {
      if(PlayerVote[x] != 0) // if this player has voted
      {
         PlayersThatVoted++;

         if(Mode == "Score")
         {
            VoteCount[PlayerVote[x]] = VoteCount[PlayerVote[x]] + int(GetPlayerScore(x));
         }

         if(Mode == "Accumulation")
         {
            VoteCount[PlayerVote[x]] = VoteCount[PlayerVote[x]] + GetAccVote(x);
         }

         if(Mode == "Elimination" || Mode == "Majority")
         {
            VoteCount[PlayerVote[x]]++; // increment the votecount for this map
            if(float(VoteCount[PlayerVote[x]]) / float(Level.Game.NumPlayers) > 0.5 && Level.Game.bGameEnded)
               bForceMapSwitch = true;
         }
      }
   }

   if(!Level.Game.bGameEnded && !bMidGameVote && (float(PlayersThatVoted) / float(Level.Game.NumPlayers)) * 100 >= MidGameVotePercent) // Mid game vote initiated
   {
      DebugLog("73");
      BroadCastMessage("Mid-Game Map Voting has been initiated !!!!");
      bMidGameVote = true;
      // Start voting count-down timer
      TimeLeft = VoteTimeLimit;
      ScoreBoardTime = 1;
      settimer(1,true);
   }
     
   index = 0;
   for(x=1;x<=MapCount;x++) // for each map
   {
      if(VoteCount[x] > 0)
      {
         Ranking[index++] = x; // copy all map indexes to the ranking list if someone has voted for it.
      }
   }

   // bubble sort ranking list by vote count
   for(x=0; x<index-1; x++)
   {
      for(y=x+1; y<index; y++)
      {
         if(VoteCount[Ranking[x]] < VoteCount[Ranking[y]])
         {
            topmap = Ranking[x];
            Ranking[x] = Ranking[y];
            Ranking[y] = topmap;
         }
      }
   }
   
   //Update Status Page
   for(x=0;x<index;x++)
   {
      MapStatusText[x] = MapList[Ranking[x]] $ "," $ VoteCount[Ranking[x]];
   }
   MapStatusText[index] = "";

   UpdateOpenWRI();

   //Check for a tie
   if(VoteCount[Ranking[0]] == VoteCount[Ranking[1]] && VoteCount[Ranking[0]] != 0)
   {
      DebugLog("74");

      TieCount = 1;
      for(x=1; x<index; x++)
      {
        if(VoteCount[Ranking[0]] == VoteCount[Ranking[x]])
           TieCount++;
      }
      //reminder ---> int Rand( int Max ); Returns a random number from 0 to Max-1.
      topmap = Ranking[Rand(TieCount)];

      // Don't allow same map to be choosen
      CurrentMap = GetURLMap();
      if(CurrentMap != "" && !(Right(CurrentMap,4) ~= ".unr"))
         CurrentMap = CurrentMap$".unr";

      x = 0;
      while(MapList[topmap] ~= CurrentMap)
      {
         topmap = Ranking[Rand(TieCount)];
         x++;
         if(x>20)
            break;  // just incase, don't want to waste alot of time choosing a random map
      }
   }
   else 
   {
      DebugLog("75");
      topmap = Ranking[0];
   }

   // check if all players have voted
   //log("Players - " $ level.game.NumPlayers);
   //log("Voted - " $ PlayersThatVoted);

   //return; // testing

   if(bForceMapSwitch)  // forces a map change even if everyone has not voted
      if(PlayersThatVoted == 0) // if noone has voted choose a map at random
      {
         topmap = Rand(MapCount) + 1;
         
	 while(Left(MapList[topmap],3) == "[X]")  // don't allow elimiated maps
            topmap = Rand(MapCount) + 1;          // select a different map
      }

   if(bForceMapSwitch || Level.Game.NumPlayers == PlayersThatVoted)  // if everyone has voted go ahead and change map
   {
      DebugLog("76");
      if(MapList[topmap] == "")
         return;
      BroadcastMessage(MapList[topmap] $ " has won." , true);
    
      CloseAllVoteWindows();
      bLevelSwitchPending = true;
      ServerTravelString = SetupGameMap(MapList[topmap]);
      ServerTravelTime = Level.TimeSeconds;
      // enable timer for mid game voting
      if(!Level.Game.bGameEnded)
         settimer(1,true);
      History = spawn(MapVoteHistoryClass);
      History.AddMap(MapList[topmap]);
      History.Save();
      History.Destroy();

      if(Mode == "Elimination")
      {
         RepeatLimit++;
         class'BDBMapVote304.BDBMapVote'.default.RepeatLimit = RepeatLimit;
         class'BDBMapVote304.BDBMapVote'.static.StaticSaveConfig();
      }

      if(Mode == "Accumulation")
      {
         SaveAccVotes(topmap);
      }
   }
   DebugLog("77");
}    
//************************************************************************************************
function UpdateOpenWRI()
{
   local MapVoteWRI MVWRI;
   local int x,y;

   DebugLog("78");

   foreach AllActors(class'BDBMapVote304.MapVoteWRI',MVWRI)
   {
      // transfer Map Voting Status to status page window
      x=0;
      MVWRI.UpdateMapVoteResults("Clear",x);
      while(MapStatusText[x] != "" && x<99)
      {
         MVWRI.UpdateMapVoteResults(MapStatusText[x],x);
         x++;
      }
      MVWRI.UpdateMapVoteResults("",x); // Mark the end
      y=0;
      // transfer Player Kick Voting Status to status page window
      MVWRI.UpdateKickVoteResults("Clear",y);
      if(bKickVote)
      {
         while(KickStatusText[y] != "" && y<99)
         {
            MVWRI.UpdateKickVoteResults(KickStatusText[y],y++);
         }
      }
      MVWRI.UpdateKickVoteResults("",y); // Mark the end
   }
   DebugLog("79");
}
//************************************************************************************************
function SortMapList()
{
   local int a,b;
   local string TempMapName,AMap,BMap;

   DebugLog("80");

   // bubble sort the map list
   for(a=1;a<=MapCount-1;a++)
   {
      for(b=a+1;b<=MapCount;b++)
      {
         AMap = Caps(MapList[a]);
	 BMap = Caps(MapList[b]);
	 
	 if(Left(AMap,3) == "[X]")
	    AMap = Mid(AMap,3);
	    
	 if(Left(BMap,3) == "[X]")
	    BMap = Mid(BMap,3);
	    
	 if(!bSortWithPreFix) // remove prefix
	 {
   	    if(Left(AMap,Len(PreFixSwap)) == PreFixSwap)
	       AMap = Mid(AMap,Len(PreFixSwap));
	    
	    if(Left(BMap,Len(PreFixSwap)) == PreFixSwap)
	       BMap = Mid(BMap,Len(PreFixSwap));
	    
	    if((bCTF && Left(AMap,3) == "CTF") || 
	       (bDOM && Left(AMap,3) == "DOM") || 
	       (bTDM && Left(AMap,3) == "TDM") ||
	       (bLMS && Left(AMap,3) == "LMS"))
	       AMap = Mid(AMap,3);

	    if((bCTF && Left(BMap,3) == "CTF") || 
	       (bDOM && Left(BMap,3) == "DOM") || 
	       (bTDM && Left(BMap,3) == "TDM") ||
	       (bLMS && Left(BMap,3) == "LMS"))
	       BMap = Mid(BMap,3);

	    if((bDM && Left(AMap,2) == "DM") || 
	       (bAS && Left(AMap,2) == "AS"))
	       AMap = Mid(AMap,2);

	    if((bDM && Left(BMap,2) == "DM") || 
	       (bAS && Left(BMap,2) == "AS"))
	       BMap = Mid(BMap,2);
	 }   
	    	 	 
         if(AMap > BMap)
         {
            TempMapName = MapList[a];
            MapList[a] = MapList[b];
            MapList[b] = TempMapName;
         }
      }
   }
}
//************************************************************************************************
function CloseAllVoteWindows()
{
   local MapVoteWRI MVWRI;

   DebugLog("81");

   foreach AllActors(class'BDBMapVote304.MapVoteWRI',MVWRI)
   {
      MVWRI.CloseWindow();
      MVWRI.Destroy();
   }
}
//************************************************************************************************
function string SetupGameMap(string MapName)
{
   local string GameType;
   local MapList myList;
   local int i;

   DebugLog("82");
   //ServerTravelString = MapList[topmap]$".unr?game="$GameType;

   
   if(OtherGameClass != None && bOther)
   {
      DebugLog("83");
      if(MapPreFixOverRide != "")  // MapPrefix overridden
      {
         if(PreFixSwap == "")
	 {
            if(left(Caps(MapName),len(MapPreFixOverRide)) ~= MapPreFixOverRide)
	       return MapName $ ".unr?game=" $ OtherClass;
	 }
	 else
	 {
            if(left(Caps(MapName),len(PreFixSwap)) ~= PreFixSwap)
	       return MapPreFixOverRide $ Mid(MapName,Len(PreFixSwap)) $ ".unr?game=" $ OtherClass;
	 }
      }
      else
      {
         if(PreFixSwap == "")
	 {
            if(left(Caps(MapName),len(OtherGameClass.default.MapPreFix)) ~= OtherGameClass.default.MapPreFix)
	       return MapName$".unr?game="$OtherClass;
	 }
	 else
	 {
            if(left(Caps(MapName),len(PreFixSwap)) ~= PreFixSwap)
	       return OtherGameClass.default.MapPreFix $ Mid(MapName,Len(PreFixSwap)) $ ".unr?game=" $ OtherClass;
	 }
      }
   }

   if(Left(Caps(MapName),2) == "DM")
      GameType = "BotPack.DeathMatchPlus";

   if(Left(Caps(MapName),3) == "LMS")
   {
      GameType = "BotPack.LastManStanding";
      MapName = "DM" $ Mid(MapName,3);  // change the prefix 
   }

   if(Left(Caps(MapName),3) == "TDM")
   {
      GameType = "BotPack.TeamGamePlus";
      MapName = "DM" $ Mid(MapName,3);  // change the prefix 
   }

   if(Left(Caps(MapName),3) == "DOM")
      GameType = "BotPack.Domination";

   if(Left(Caps(MapName),3) == "CTF") 
      GameType = "BotPack.CTFGame";

   if(Left(Caps(MapName),2) == "AS")
   {
      GameType = "BotPack.Assault";
      // if playing assault in second half and switching to a different assault map
      if(Level.Game.IsA('Assault') &&  Assault(Level.Game).bDefenseSet)
      {
         Assault(Level.Game).ResetGame();  // resets assault ini settings so next game starts on first half of game instead of second
      }
      else
      {
         // this should make sure that we start in the first half
         class'Assault'.default.bDefenseSet = false;
         class'Assault'.static.StaticSaveConfig();
      }
   }

   return MapName$".unr?game="$GameType;
}
//************************************************************************************************
function LoadMaps()
{
   local MapVoteHistory History;
   local int pos;
   local string GamePackage,NewPreFix;

   DebugLog("84");

   MapVoteHistoryClass = class<MapVoteHistory>(DynamicLoadObject(MapVoteHistoryType, class'Class'));
   History = spawn(MapVoteHistoryClass);

   if(History == None) // Failed to spawn MapVoteHistory
   {
      DebugLog("89");
      History = spawn(class'MapVoteHistory1');
   }

   MapCount = 0;
   MarkedMapCount = 0;

   if(bAutoDetect)
   {
      log("Detected GameType = "$string(Level.Game.Class));
      bAS=False;
      bCTF=False;
      bDM=False;
      bLMS=False;
      bTDM=False;
      bDOM=False;
      bOther=False;
      if(string(Level.Game.Class) ~= "Botpack.Assault")
         bAS=True;
      else if(string(Level.Game.Class) ~= "Botpack.CTFGame")
         bCTF=True;
      else if(string(Level.Game.Class) ~= "Botpack.DeathMatchPlus")
         bDM=True;
      else if(string(Level.Game.Class) ~= "Botpack.LastManStanding")
         bLMS=True;
      else if(string(Level.Game.Class) ~= "Botpack.TeamGamePlus")
         bTDM=True;
      else if(string(Level.Game.Class) ~= "Botpack.Domination")
         bDOM=True;
      else
      {
         bOther=True;
         OtherClass=string(Level.Game.Class);
      }

   }

   if(bOther)
      OtherGameClass = class<GameInfo>(DynamicLoadObject(OtherClass, class'Class'));

   if(bAS)
   {
      if(bUseMapList)
         LoadMapCycleList(class'Botpack.Assault'.default.MapListType,"AS","AS",History);
      else
         LoadMapTypes("AS","AS",History);
   }
   
   if(bCTF) // Load Capture The Flag Maps
   {
      if(bUseMapList)
         LoadMapCycleList(class'Botpack.CTFGame'.default.MapListType,"CTF","CTF",History);
      else
         LoadMapTypes("CTF","CTF",History);
   }

   if(bDM) // Load DeathMatch Maps
   {
      if(bUseMapList)
         LoadMapCycleList(class'Botpack.DeathMatchPlus'.default.MapListType,"DM","DM",History);
      else
         LoadMapTypes("DM","DM",History);
   }

   if(bDOM) // Load Domination Maps
   {
      if(bUseMapList)
         LoadMapCycleList(class'Botpack.Domination'.default.MapListType,"DOM","DOM",History);
      else
         LoadMapTypes("DOM","DOM",History);
   }

   if(bTDM) // Load TeamDeathMatch Maps
   {
      if(bUseMapList)
         LoadMapCycleList(class'Botpack.TeamGamePlus'.default.MapListType,"DM","TDM",History);
      else
         LoadMapTypes("DM","TDM",History);
   }

   if(bLMS) // Load LastManStanding Maps
   {
      if(bUseMapList)
         LoadMapCycleList(class'Botpack.LastManStanding'.default.MapListType,"DM","LMS",History);
      else
         LoadMapTypes("DM","LMS",History);
   }

   if(bOther && OtherGameClass != None) // Load Other Maps
   {
      DebugLog("85");
      if(PreFixSwap != "")
         NewPreFix = PreFixSwap;
      else
      {
         if(MapPreFixOverRide == "")
            NewPreFix = OtherGameClass.default.MapPreFix;
	 else
	    NewPreFix = MapPreFixOverRide;
      }
      if(bUseMapList)
      {
         if(MapPreFixOverRide == "")
            LoadMapCycleList(OtherGameClass.default.MapListType,OtherGameClass.default.MapPreFix,NewPreFix,History);
	 else
            LoadMapCycleList(OtherGameClass.default.MapListType,MapPreFixOverRide,NewPreFix,History);
      }
      else
      {
         if(MapPreFixOverRide == "")
            LoadMapTypes(OtherGameClass.default.MapPreFix,NewPreFix,History);
         else
            LoadMapTypes(MapPreFixOverRide,NewPreFix,History);
      }
      if(HasStartWindow == "Auto")
      {
         GamePackage = Caps(string(Level.Game.Class));
         pos = InStr(GamePackage,".");
         if(pos > 0)
            GamePackage = left(GamePackage,pos);

         if(GamePackage=="S_SWAT" || GamePackage =="WFCODE" || GamePackage =="ROCKETARENA")
            HasStartWindow = "Yes"; // these Mods have start windows
         else
            HasStartWindow = "No";
      }
   }
   History.Destroy();

   if(Mode == "Elimination")
   {
      //if(MapCount < MinMapCount || (MapCount == 0 && RepeatLimit > 0))
	  // fix, Thanks to Mr.Mitchell for finding this bug
      if( (MapCount-MarkedMapCount) < MinMapCount || ((MapCount-MarkedMapCount) == 0 && RepeatLimit > 0))
      {
         RepeatLimit = 0;
         LoadMaps();
         return;
      }
   }
   log("Total Maps = "$ MapCount);
}
//*******************************************************************************
function LoadMapTypes(string PreFix,string PreFixChange,MapVoteHistory History)
{
   local string FirstMap,NextMap,MapName,TestMap;
   local int z;

   DebugLog("86");

   FirstMap = Level.GetMapName(PreFix, "", 0);
   NextMap = FirstMap;
   while(!(FirstMap ~= TestMap))
   {
      MapName = NextMap;
      z = InStr(Caps(MapName), ".UNR");
      if(z != -1)
         MapName = Left(MapName, z);  // remove ".unr"

      MapName = PreFixChange $ Mid(MapName,Len(PreFix));  // change the prefix
      
      if(InStr(Caps(NextMap),"TUTORIAL") == -1)  // dont load tutorial maps
      {
         if(History.GetMapSequence(MapName) <= RepeatLimit)
		 {
            MapName = "[X]" $ MapName;  // mark this map so it can't be voted for
			MarkedMapCount++;
         }

         MapList[++MapCount] = MapName;
      }
      NextMap = Level.GetMapName(PreFix, NextMap, 1);
      TestMap = NextMap;
      if(MapCount > 1020)
         break;
   }
}
//*******************************************************************************
function LoadMapCycleList(class<MapList> MapListType,string PreFix,string PreFixChange,MapVoteHistory History)
{
   local MapList MapCycleList;
   local string MapName;
   local int x,z;

   DebugLog("87");

   MapCycleList = spawn(MapListType);
   if(MapCycleList != none)
   {
      x = 0;
      While(x<32 && MapCycleList.Maps[x]!="")
      {
         MapName = MapCycleList.Maps[x++];
         z = InStr(Caps(MapName), ".UNR");
         if(z != -1)
            MapName = Left(MapName, z); // remove ".unr"
         MapName = PreFixChange $ Mid(MapName,Len(PreFix));  // change the prefix
         if(History.GetMapSequence(MapName) <= RepeatLimit)
		 {
            MapName = "[X]" $ MapName;  // mark this map so it can't be voted for
			MarkedMapCount++;
         }
	    
         MapList[++MapCount] = MapName;
      }
      MapCycleList.Destroy();
   }
   else
      Log("MapList Spawn Failed");
}

function DebugLog(string Msg)
{
   if(bDebugMode)
      Log("MV " $ Msg);
}

//************************************************************************************************

defaultproperties
{
    bAutoDetect=True
    bSortWithPreFix=True
    VoteTimeLimit=70
    KickPercent=51
    ScoreBoardDelay=10
    bAutoOpen=True
    bKickVote=True
    RepeatLimit=4
    MapVoteHistoryType="BDBMapVote304.MapVoteHistory1"
    MidGameVotePercent=50
    Mode="Majority"
    MinMapCount=2
    HasStartWindow="Auto"
    bEntryWindows=True
    MsgTimeOut=10
    bLoadScreenShot=True
}
